/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/ 

/**
 * \file    nandflash.h
 *
 * \brief   Defines the module register defines for NAND Flash 
 *
 * This header file contains the Macros definitions and NAND flash
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _nandflash_H_
#define _nandflash_H_
/*========================
 * Includes
 *========================
 */
 
#include "DM814x_types.h"
#include "DM814x_EVM.h"
/*=========================
 * Defines
 *=========================
 */

#define NANDFLASH_BASE                  0x50000000  // Low CS
#define NANDFLASH_BLOCKS                2048 
#define NANDFLASH_PAGESPERBLOCK         64
#define NANDFLASH_PAGES                 (NANDFLASH_BLOCKS * NANDFLASH_PAGESPERBLOCK)
#define NANDFLASH_PAGESIZE              2048
#define NANDFLASH_SPARESIZE             64

/* Number of blocks to test the erase, read/write */
#define NANDFLASH_BLOCKS_TEST		4

#define NANDFLASH_CLE   *( volatile UINT16* )( NANDFLASH_BASE + 0x7C )
#define NANDFLASH_ALE   *( volatile UINT16* )( NANDFLASH_BASE + 0x80 )
#define NANDFLASH_DATA  *( volatile UINT16* )( NANDFLASH_BASE + 0x84 )

#define CMD_READ                    0x0000
#define CMD_READID                  0x0090
#define CMD_READ_CONFIRM            0x0030
#define CMD_PROGRAM                 0x0080
#define CMD_PROGRAM_CONFIRM         0x0010
#define CMD_ERASE                   0x0060
#define CMD_ERASE_CONFIRM           0x00d0
#define CMD_STATUS                  0x0070
#define CMD_RESET                   0x00ff

/*
 *======================
 *Function Declarations
 *======================
 */
  
STATUS nand_init();
STATUS nand_eraseBlock(UINT32 blocknum);
STATUS nand_readPage(UINT32 pagenum, UINT16 *buf, UINT16 len);
STATUS nand_writePage(UINT32 pagenum, UINT16 *buf, UINT16 len);

#endif /* _nandflash_H_ */
